<?php 
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$db = new SQLite3('api/.db.db');

// Consulta SQL para obter URLs da tabela "dns"
$dns_query = $db->query('SELECT DISTINCT url FROM dns');
$today = date('Y-m-d');

$message = ''; // variável para armazenar a mensagem de sucesso

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['new_dns']) && isset($_POST['old_dns'])) {
    $new_dns = $db->escapeString($_POST['new_dns']);
    $old_dns = $db->escapeString($_POST['old_dns']);

    // Atualizar a URL no banco de dados
    $db->exec("UPDATE dns SET url = '$new_dns' WHERE url = '$old_dns'");
    $message = 'URL atualizada com sucesso!'; // definindo a mensagem de sucesso
}

include 'includes/header.php';
?>

<main role="main" class="container pt-4">
    <div class="row justify-content-center">
        <div id="main" class="col-12">
            <img src="fotodns.png" alt="Imagem de Migração DNS" class="img-fluid mx-auto d-block" style="max-width: 200px;" />
            <?php if (!empty($message)) : ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo $message; ?>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            <?php endif; ?>

            <h1 class="h3 mb-3 text-gray-800 text-center">Migração DNS </h1>
            <div class="table-responsive">
                <table class="table table-striped table-sm">
                    <thead class="text-primary">
                        <tr>
                            <th>URL</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>
                                <form method="POST" action="">
                                    <div class="form-group">
                                        <label for="old_dns">Selecione a URL para atualizar</label>
                                        <select class="form-control" name="old_dns" id="old_dns">
                                            <?php
                                            // Exibir as URLs salvas na tabela "dns"
                                            while ($dns_row = $dns_query->fetchArray()) {
                                                $url = htmlspecialchars($dns_row['url']);
                                                echo '<option value="' . $url . '">' . $url . '</option>';
                                            }
                                            ?>
                                        </select>
                                    </div>
                                    <div class="form-group mt-2">
                                        <label for="new_dns">Nova URL</label>
                                        <input type="text" class="form-control" id="new_dns" name="new_dns" required>
                                    </div>
                                    <button type="submit" class="btn btn-primary">Atualizar URL</button>
                                </form>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<?php
include 'includes/footer.php';
?>
<script>
    // Script para fechar a mensagem de sucesso após alguns segundos
    setTimeout(function() {
        $('.alert').alert('close');
    }, 5000);
</script>
</body>
</html>
